<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAvailableForTable extends Migration
{
    public function up()
    {
        Schema::create('available_for', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('profile_id')->unsigned()->notNullable();
            $table->enum('service_type', ['regular_babysitting', 'occasional_babysitting', 'after_school_care', 'full_time_nanny'])->notNullable();
            $table->timestamp('created_at')->useCurrent();

            $table->foreign('profile_id')->references('Profile_id')->on('candidate_profiles')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('available_for');
    }
}
